

def import_clustering_sets(filename):

    with open(filename, 'r') as file:
        data = file.readlines()

    tests = {}
    current_test = None

    for line in data:
        line = line.strip()

        if line.startswith('Test'):
            # Extract test number
            current_test = line.split()[1]
            tests[current_test] = {}

        elif line.startswith('Candidate Cluster') or line.startswith('Voter Cluster'):
            # Extract cluster number and associated set of candidates
            parts = line.split(':')
            cluster_number = parts[0].split()[-1]
            candidates = eval(parts[1].strip())  # Safely converts string "{x, y, z}" to set
            tests[current_test][cluster_number] = candidates
    return tests